﻿namespace Microsoft.Samples.PlanMyNight.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.Serialization;

    [DataContract]
    public class PagingResult<T>
    {
        public PagingResult()
        {
        }

        public PagingResult(IEnumerable<T> items)
        {
            this.Items = new List<T>(items);
        }

        [DataMember]
        public int PageSize { get; set; }

        [DataMember]
        public int TotalItems { get; set; }

        [DataMember]
        public int CurrentPage { get; set; }

        [DataMember]
        public ICollection<T> Items { get; set; }

        public int TotalPages
        {
            get
            {
                return (int)Math.Ceiling((decimal)this.TotalItems / this.PageSize);
            }
        }
    }
}
